/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.engine.RenderConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class HandRenderScreen
extends Screen {
    private final IChangeCallback callback;
    private boolean enabled;
    private final RenderConfig.Mutable leftHand;
    private final RenderConfig.Mutable rightHand;
    private SelectorWidget<HandSide> handSelector;
    private TextFieldWidget posX;
    private TextFieldWidget posY;
    private TextFieldWidget posZ;
    private TextFieldWidget scaleX;
    private TextFieldWidget scaleY;
    private TextFieldWidget scaleZ;
    private TextFieldWidget degrees;
    private TextFieldWidget rotationX;
    private TextFieldWidget rotationY;
    private TextFieldWidget rotationZ;

    public HandRenderScreen(RenderConfig.Mutable left, RenderConfig.Mutable right, IChangeCallback callback, boolean isEnabled) {
        super((ITextComponent)new TranslationTextComponent("screen.dev_tool.hand_config"));
        this.leftHand = left;
        this.rightHand = right;
        this.callback = callback;
        this.enabled = isEnabled;
    }

    protected void func_231160_c_() {
        Button toClipboard = new Button(5, 40, 50, 20, (ITextComponent)new StringTextComponent("Copy"), this::copy_Clicked);
        Button reset = new Button(5, 65, 50, 20, (ITextComponent)new StringTextComponent("Clear"), this::reset_Clicked);
        CheckboxWidget active = new CheckboxWidget(5, 90, 60, 20, (ITextComponent)new StringTextComponent("Active"), this.enabled).onClicked(this::checkbox_Change);
        this.handSelector = new SelectorWidget<HandSide>(5, 15, 50, 20, HandSide.values(), side -> new StringTextComponent(side.name())).onValueChanged(this::selector_OnChange);
        this.posX = new TextFieldWidget(this.field_230712_o_, 60, 15, 50, 20, StringTextComponent.field_240750_d_);
        this.posX.func_212954_a(this::posX_Changed);
        this.posY = new TextFieldWidget(this.field_230712_o_, 60, 40, 50, 20, StringTextComponent.field_240750_d_);
        this.posY.func_212954_a(this::posY_Changed);
        this.posZ = new TextFieldWidget(this.field_230712_o_, 60, 65, 50, 20, StringTextComponent.field_240750_d_);
        this.posZ.func_212954_a(this::posZ_Changed);
        this.scaleX = new TextFieldWidget(this.field_230712_o_, 115, 15, 50, 20, StringTextComponent.field_240750_d_);
        this.scaleX.func_212954_a(this::scaleX_Changed);
        this.scaleY = new TextFieldWidget(this.field_230712_o_, 115, 40, 50, 20, StringTextComponent.field_240750_d_);
        this.scaleY.func_212954_a(this::scaleY_Changed);
        this.scaleZ = new TextFieldWidget(this.field_230712_o_, 115, 65, 50, 20, StringTextComponent.field_240750_d_);
        this.scaleZ.func_212954_a(this::scaleZ_Changed);
        this.degrees = new TextFieldWidget(this.field_230712_o_, 170, 15, 50, 20, StringTextComponent.field_240750_d_);
        this.degrees.func_212954_a(this::degrees_Changed);
        this.rotationX = new TextFieldWidget(this.field_230712_o_, 170, 40, 50, 20, StringTextComponent.field_240750_d_);
        this.rotationX.func_212954_a(this::rotationX_Changed);
        this.rotationY = new TextFieldWidget(this.field_230712_o_, 170, 65, 50, 20, StringTextComponent.field_240750_d_);
        this.rotationY.func_212954_a(this::rotationY_Changed);
        this.rotationZ = new TextFieldWidget(this.field_230712_o_, 170, 90, 50, 20, StringTextComponent.field_240750_d_);
        this.rotationZ.func_212954_a(this::rotationZ_Changed);
        this.selector_OnChange(HandSide.LEFT, HandSide.LEFT);
        this.func_230480_a_((Widget)toClipboard);
        this.func_230480_a_((Widget)reset);
        this.func_230480_a_(active);
        this.func_230480_a_(this.handSelector);
        this.func_230480_a_((Widget)this.posX);
        this.func_230480_a_((Widget)this.posY);
        this.func_230480_a_((Widget)this.posZ);
        this.func_230480_a_((Widget)this.scaleX);
        this.func_230480_a_((Widget)this.scaleY);
        this.func_230480_a_((Widget)this.scaleZ);
        this.func_230480_a_((Widget)this.degrees);
        this.func_230480_a_((Widget)this.rotationX);
        this.func_230480_a_((Widget)this.rotationY);
        this.func_230480_a_((Widget)this.rotationZ);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float deltaRenderTime) {
        this.func_230446_a_(matrix);
        this.field_230712_o_.func_238421_b_(matrix, "Handside", 5.0f, 5.0f, 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(matrix, "Pos", 60.0f, 5.0f, 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(matrix, "Scale", 115.0f, 5.0f, 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(matrix, "Rotation", 170.0f, 5.0f, 0xFFFFFF);
        super.func_230430_a_(matrix, mouseX, mouseY, deltaRenderTime);
    }

    private void posX_Changed(String value) {
        this.updatePos(value, this.posX, (value1, old) -> new Vector3d(value1, old.field_72448_b, old.field_72449_c));
    }

    private void posY_Changed(String value) {
        this.updatePos(value, this.posY, (value1, old) -> new Vector3d(old.field_72450_a, value1, old.field_72449_c));
    }

    private void posZ_Changed(String value) {
        this.updatePos(value, this.posZ, (value1, old) -> new Vector3d(old.field_72450_a, old.field_72448_b, value1));
    }

    private void scaleX_Changed(String value) {
        this.updateScale(value, this.scaleX, Vector3f::setX);
    }

    private void scaleY_Changed(String value) {
        this.updateScale(value, this.scaleY, Vector3f::setY);
    }

    private void scaleZ_Changed(String value) {
        this.updateScale(value, this.scaleZ, Vector3f::setZ);
    }

    private void degrees_Changed(String value) {
        this.updateRotation(value, this.degrees, (degrees1, x, y, z, val) -> new Vector3f(x, y, z).func_229187_a_(val));
    }

    private void rotationX_Changed(String value) {
        this.updateRotation(value, this.rotationX, (degrees1, x, y, z, val) -> new Vector3f(val, y, z).func_229187_a_(degrees1));
    }

    private void rotationY_Changed(String value) {
        this.updateRotation(value, this.rotationY, (degrees1, x, y, z, val) -> new Vector3f(x, val, z).func_229187_a_(degrees1));
    }

    private void rotationZ_Changed(String value) {
        this.updateRotation(value, this.rotationZ, (degrees1, x, y, z, val) -> new Vector3f(x, y, val).func_229187_a_(degrees1));
    }

    private void updatePos(String value, TextFieldWidget widget, PosSetFunction function) {
        RenderConfig.Mutable cfg = this.getActiveConfig();
        try {
            double val = Double.parseDouble(value);
            widget.func_146193_g(0xE0E0E0);
            Vector3d old = cfg.getPosition();
            cfg.setPosition(function.getPos(val, old));
        }
        catch (NumberFormatException nfe) {
            widget.func_146193_g(0xE00000);
        }
    }

    private void updateScale(String value, TextFieldWidget widget, BiConsumer<Vector3f, Float> setter) {
        RenderConfig.Mutable cfg = this.getActiveConfig();
        try {
            float f = Float.parseFloat(value);
            widget.func_146193_g(0xE0E0E0);
            setter.accept(cfg.getScale(), Float.valueOf(f));
        }
        catch (NumberFormatException nfe) {
            widget.func_146193_g(0xE00000);
        }
    }

    private void updateRotation(String value, TextFieldWidget widget, RotationSetFunction function) {
        RenderConfig.Mutable cfg = this.getActiveConfig();
        try {
            float f = Float.parseFloat(value);
            widget.func_146193_g(0xE0E0E0);
            float d = this.getFloat(this.degrees.func_146179_b());
            float x = this.getFloat(this.rotationX.func_146179_b());
            float y = this.getFloat(this.rotationY.func_146179_b());
            float z = this.getFloat(this.rotationZ.func_146179_b());
            Quaternion quaternion = function.getRot(d, x, y, z, f);
            cfg.setRotation(quaternion);
        }
        catch (NumberFormatException nfe) {
            widget.func_146193_g(0xE00000);
        }
    }

    private float getFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }

    private void reset_Clicked(Button resetButton) {
        this.rightHand.toDefaults();
        this.leftHand.toDefaults();
        HandSide side = this.handSelector.getValue();
        this.selector_OnChange(side, side);
    }

    private void copy_Clicked(Button copyButton) {
        String left = this.getConfigDef(this.leftHand);
        String right = this.getConfigDef(this.rightHand);
        this.field_230706_i_.field_195559_v.func_197960_a("//Hand render config\n//right\n" + right + "\n//left\n" + left);
    }

    private String getConfigDef(RenderConfig.Mutable cfg) {
        Vector3d position = cfg.getPosition();
        Vector3f scale = cfg.getScale();
        Quaternion rotation = cfg.getRotation();
        if (scale.equals((Object)new Vector3f(1.0f, 1.0f, 1.0f)) && rotation.equals((Object)Quaternion.field_227060_a_)) {
            return String.format(Locale.ROOT, "new PositionConfig(new Vector3d(%.3f, %.3f, %.3f));", position.field_72450_a, position.field_72448_b, position.field_72449_c);
        }
        return String.format(Locale.ROOT, "RenderConfig.newDef().withPosition(%.3f, %.3f, %.3f).withScale(%.3fF, %.3fF, %.3fF).withRotation(new Quaternion(%.3fF, %.3fF, %.3fF, %.3fF)).finish();", position.field_72450_a, position.field_72448_b, position.field_72449_c, Float.valueOf(scale.func_195899_a()), Float.valueOf(scale.func_195900_b()), Float.valueOf(scale.func_195902_c()), Float.valueOf(rotation.func_195889_a()), Float.valueOf(rotation.func_195891_b()), Float.valueOf(rotation.func_195893_c()), Float.valueOf(rotation.func_195894_d()));
    }

    private void checkbox_Change(boolean isChecked) {
        this.enabled = isChecked;
        this.callback.stateChanged(isChecked);
    }

    private void selector_OnChange(HandSide current, HandSide old) {
        RenderConfig.Mutable config = current == HandSide.RIGHT ? this.rightHand : this.leftHand;
        Vector3d pos = config.getPosition();
        Vector3f scale = config.getScale();
        this.posX.func_146180_a(String.valueOf(pos.field_72450_a));
        this.posY.func_146180_a(String.valueOf(pos.field_72448_b));
        this.posZ.func_146180_a(String.valueOf(pos.field_72449_c));
        this.scaleX.func_146180_a(String.valueOf(scale.func_195899_a()));
        this.scaleY.func_146180_a(String.valueOf(scale.func_195900_b()));
        this.scaleZ.func_146180_a(String.valueOf(scale.func_195902_c()));
        Quaternion rotation = config.getRotation();
        Pair<Float, Vector3f> transformed = AnimationUtils.getVectorWithRotation(rotation);
        float f = ((Float)transformed.getLeft()).floatValue();
        Vector3f vec = (Vector3f)transformed.getRight();
        this.degrees.func_146180_a(String.format(Locale.ROOT, "%.2f", Float.valueOf(f)));
        this.rotationX.func_146180_a(String.format(Locale.ROOT, "%.2f", Float.valueOf(vec.func_195899_a())));
        this.rotationY.func_146180_a(String.format(Locale.ROOT, "%.2f", Float.valueOf(vec.func_195900_b())));
        this.rotationZ.func_146180_a(String.format(Locale.ROOT, "%.2f", Float.valueOf(vec.func_195902_c())));
    }

    private RenderConfig.Mutable getActiveConfig() {
        return this.handSelector.getValue() == HandSide.RIGHT ? this.rightHand : this.leftHand;
    }

    private static interface RotationSetFunction {
        public Quaternion getRot(float var1, float var2, float var3, float var4, float var5);
    }

    private static interface PosSetFunction {
        public Vector3d getPos(double var1, Vector3d var3);
    }

    public static class CheckboxWidget
    extends Widget {
        private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/checkbox.png");
        private boolean checked;
        private ISelectionChanged callback;

        public CheckboxWidget(int x, int y, int width, int height, ITextComponent text, boolean initialState) {
            super(x, y, width, height, text);
            this.checked = initialState;
        }

        public CheckboxWidget onClicked(ISelectionChanged event) {
            this.callback = event;
            return this;
        }

        public void func_230982_a_(double p_230982_1_, double p_230982_3_) {
            boolean bl = this.checked = !this.checked;
            if (this.callback != null) {
                this.callback.onChange(this.checked);
            }
        }

        public void func_230431_b_(MatrixStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(TEXTURE);
            RenderSystem.enableDepthTest();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            CheckboxWidget.func_238463_a_((MatrixStack)p_230431_1_, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)(this.func_230999_j_() ? 20.0f : 0.0f), (float)(this.checked ? 20.0f : 0.0f), (int)20, (int)this.field_230689_k_, (int)64, (int)64);
            this.func_230441_a_(p_230431_1_, minecraft, p_230431_2_, p_230431_3_);
            if (this.func_230458_i_() != null) {
                CheckboxWidget.func_238475_b_((MatrixStack)p_230431_1_, (FontRenderer)fontrenderer, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + 24), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)(0xE0E0E0 | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
            }
        }

        public static interface ISelectionChanged {
            public void onChange(boolean var1);
        }
    }

    public static class SelectorWidget<T>
    extends Widget {
        private final T[] values;
        private final Function<T, ITextComponent> translator;
        private int currentIndex;
        private IValueChanged<T> valueChanged;

        public SelectorWidget(int x, int y, int width, int height, T[] values, Function<T, ITextComponent> translator) {
            super(x, y, width, height, StringTextComponent.field_240750_d_);
            this.values = values;
            this.translator = translator;
            this.func_238482_a_(this.getDisplayName());
        }

        public SelectorWidget<T> onValueChanged(IValueChanged<T> callback) {
            this.valueChanged = callback;
            return this;
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            T old = this.getValue();
            int nextIndex = this.currentIndex + 1;
            if (nextIndex >= this.values.length) {
                nextIndex = 0;
            }
            this.currentIndex = nextIndex;
            T next = this.getValue();
            this.func_238482_a_(this.translator.apply(next));
            if (this.valueChanged != null) {
                this.valueChanged.valueChanged(next, old);
            }
        }

        public ITextComponent getDisplayName() {
            return this.translator.apply(this.getValue());
        }

        public T getValue() {
            return this.values[this.currentIndex];
        }

        public static interface IValueChanged<T> {
            public void valueChanged(T var1, T var2);
        }
    }

    public static interface IChangeCallback {
        public void stateChanged(boolean var1);
    }
}

